package edu.cmu.cs.cs214.streamio;

import java.io.*;

public class FileObjectExample {

    /**
     * @param args
     * @throws IOException 
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("usage: java edu.cmu.cs.cs214.streamio.FileObjectExample filename");
            System.exit(-1);
        }
        String fileName = args[0];

        try {
            ObjectOutputStream out = new ObjectOutputStream(
                                           new FileOutputStream(fileName));
            
            QABean x = new QABean("How many roads must a man walk down?", 42);
            
            out.writeObject(x);
            out.writeObject(x);
            out.close();
        } catch (IOException e) {
            System.err.println("Caught exception " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }
}
